PSCAD 4.2.0

Settings
 {
 Id = "895758802.1144791033"
 Author = "nayak.jayas"
 Desc = "A Simple Multiple Run Example"
 Arch = "windows"
 Options = 0
 Build = 18
 Warn = 1
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 0.001
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = "mrun.snp"
  OFile = "test.out"
  SFile = "mrun.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  freq = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144791015
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Portrait,16,[597,467],100)
   {
   -Wire-([756,918],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([756,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([756,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([954,918],0,42143768,160)
    {
    Name = "Fault Delay"
    Group = "Fault Monitoring"
    Display = "0"
    Scale = "1.0"
    Units = "s"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = ".02"
    }
   0.pgb([954,954],0,42146944,150)
    {
    Name = "Fault Type"
    Group = "Fault Monitoring"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "12.0"
    }
   -Wire-([900,918],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([936,918],2,0,-1)
    {
    Name = "FDelay"
    }
   0.datalabel([936,954],2,0,-1)
    {
    Name = "FaultType"
    }
   -Wire-([900,954],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([846,828],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.datalabel([846,828],2,0,-1)
    {
    Name = "ENAB"
    }
   -ControlPanel-([414,1098],0)
    {
    Name = ""
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 414,1098
    Extents = 0,0,144,126
    Meter(42143768)
    Meter(42146944)
    }
   -Sticky-([72,72],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,72,504,360
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
A simple case illustrating the multiple run feature of PSCAD using the single line diagram view.

- find the maximum overvoltage on a bus for different fault types applied at different times

- it is possible to take a snapshot  when a steady state
  is reached and then run multiple simulation from the snapshot;
  the steps which have to be done are:
  - disable the mrun block
  - set a snapshot at 0.3 sec (Project Settings of the case)
  - run the case
  - enable the mrun block
  - set startup of the case form snapshot and change simulation 
    time to 0.1sec  (Project Settings of the case)
  - run the case
"
    }
   -Sticky-([414,1278],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 414,1278,558,1368
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Monitoring the changes in variables:
   - fault delay time
   - fault type"
    }
   -Sticky-([900,648],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 900,648,1170,792
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "\
Connection  Meas-Enab can be set to 0 to reset the automatic processing functions of Multiple Run, and set to 1 to enable them (this is useful to avoid the recording of transients during startup or initialization).

Here it will start looking for maximum overvoltages only after the minimum fault time.    "
    }
   0.var([144,1152],0,25970776,60)
    {
    Name = "Initial Fault Time"
    Group = "Fault Start Time Control"
    Display = "0"
    Max = "10"
    Min = "0.0"
    Value = "0.32"
    Units = "s"
    Collect = "1"
    }
   -Wire-([180,1152],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([216,1152],2,0,-1)
    {
    Name = "FStart"
    }
   0.sumjct([270,1152],0,0,110)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.datalabel([216,1188],2,0,-1)
    {
    Name = "FDelay"
    }
   -Wire-([216,1188],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([306,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([342,1152],2,0,-1)
    {
    Name = "FltTime"
    }
   0.datalabel([774,918],4,0,-1)
    {
    Name = "Va"
    }
   0.datalabel([774,954],4,0,-1)
    {
    Name = "Vb"
    }
   0.datalabel([774,990],4,0,-1)
    {
    Name = "Vc"
    }
   0.compar([720,828],0,0,120)
    {
    Pulse = "0"
    INTR = "0"
    OPos = "1"
    ONone = "0"
    ONeg = "1"
    OHi = "1"
    OLo = "0"
    }
   -Wire-([846,828],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datalabel([666,864],2,0,-1)
    {
    Name = "FltTime"
    }
   0.time-sig([666,828],0,0,20)
    {
    }
   -Wire-([666,864],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([702,828],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -SrcFile-([1008,216],0)
    {
   Name = "multirun_sld.emt\\mrunout.out"
    }
   -Sticky-([936,90],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 936,90,1152,180
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "\
Table summarizing multiple run data:
- Run #
- Fault Delay Time and Fault Type
- Overvoltages and A, B and C
"
    }
   -Wire-([720,396],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.datalabel([648,108],6,0,-1)
    {
    Name = "Va"
    }
   0.datalabel([648,144],6,0,-1)
    {
    Name = "Vb"
    }
   0.datalabel([648,180],6,0,-1)
    {
    Name = "Vc"
    }
   0.maxmin([756,144],0,0,100)
    {
    DPath = "1"
    Type = "1"
    A = "0"
    B = "0"
    C = "1"
    D = "1"
    E = "1"
    F = "0"
    G = "0"
    }
   0.datalabel([792,144],6,0,-1)
    {
    Name = "Vmax"
    }
   0.abs([684,108],0,0,70)
    {
    Dim = "1"
    }
   0.abs([684,144],0,0,80)
    {
    Dim = "1"
    }
   0.abs([684,180],0,0,90)
    {
    Dim = "1"
    }
   0.datalabel([774,1026],4,0,-1)
    {
    Name = "Vmax"
    }
   -Wire-([774,1026],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Sticky-([756,198],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 756,198,828,234
    Alignment = 1
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Peak Detector"
    }
   0.source_3([180,396],0,0,-1)
    {
    Name = "Source1"
    Type = "4"
    Grnd = "1"
    View = "1"
    Spec = "0"
    VCtrl = "0"
    FCtrl = "0"
    Vm = "230.0 [kV]"
    Tc = "0.05 [s]"
    f = "$(freq)"
    Ph = "-90.0 [deg]"
    Vbase = "230.0 [kV]"
    Sbase = "100.0 [MVA]"
    Vpu = "1.0 [pu]"
    PhT = "0.0 [deg]"
    Pinit = "0.0 [pu]"
    Qinit = "0.0 [pu]"
    R = "1.0 [ohm]"
    Rs = "1.0 [ohm]"
    Rp = "1.0 [ohm]"
    Lp = "0.1 [H]"
    R' = "1.0 [ohm]"
    L = "0.1 [H]"
    C = "1.0 [uF]"
    L' = "0.1 [H]"
    C' = "1.0 [uF]"
    IA = ""
    IB = ""
    IC = ""
    }
   0.xfmr-3p2w([468,396],0,0,-1)
    {
    Name = "T1"
    Tmva = "100.0 [MVA]"
    f = "$(freq)"
    YD1 = "0"
    YD2 = "0"
    Lead = "1"
    Xl = "0.1 [pu]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0"
    View = "1"
    Dtls = "0"
    V1 = "230.0 [kV]"
    V2 = "230.0 [kV]"
    Enab = "1"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [s]"
    Im1 = "2.0 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   0.ground([450,432],1,0,-1)
    {
    }
   0.ground([468,432],1,0,-1)
    {
    }
   -Wire-([252,396],0,0,-1)
    {
    Vertex="0,0;162,0"
    }
   -Wire-([306,396],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.tpflt([288,486],0,0,180)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datalabel([378,504],2,0,-1)
    {
    Name = "FaultType"
    }
   -Wire-([324,504],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([324,594],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([342,594],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.tfault([378,594],0,0,170)
    {
    TF = "FltTime"
    DF = "0.02 [s]"
    REP = "0"
    }
   -Sticky-([450,576],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 450,576,684,666
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "\
Time to apply fault
It is the first variable changed by the Multiple Run. Its value is changing from 0.32 sec to 0.33 sec with a step of 0.001sec."
    }
   -Wire-([558,396],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.newpi([594,396],0,0,-1)
    {
    Name = "Line1"
    PU = "1"
    Config = "1"
    F = "$(freq)"
    len = "1.0E5 [m]"
    Estim = "0"
    View = "1"
    REst = "1.5"
    ZEst = "1.5"
    TEst = "1.5"
    VR = "230.0 [kV]"
    MVA = "100.0 [MVA]"
    RPUP = ".336786E-7 [pu/m]"
    XLPUP = ".593346E-6 [pu/m]"
    XCPUP = ".517098E6 [pu*m]"
    RPUZ = ".558072E-6 [pu/m]"
    XLPUZ = ".196578E-5 [pu/m]"
    XCPUZ = ".782919E6 [pu*m]"
    Rp = ".17816E-4 [ohm/m]"
    Xp = ".31388E-3 [ohm/m]"
    Bp = "273.545 [Mohm*m]"
    Rz = ".29522E-3 [ohm/m]"
    Xz = ".10399E-2 [ohm/m]"
    Bz = "414.164 [Mohm*m]"
    RTP = ".17816E-4 [ohm/m]"
    TTP = ".3411107 [ms]"
    ZTP = "293.1393 [ohm]"
    RTZ = ".29522E-3 [ohm/m]"
    TTZ = ".509334 [ms]"
    ZTZ = "662.7141 [ohm]"
    VR2 = "230.0 [kV]"
    MVA2 = "100.0 [MVA]"
    RPUP2 = ".336786E-7 [pu/m]"
    XLPUP2 = ".593346E-6 [pu/m]"
    BPUP2 = "1.93387E-6 [pu/m]"
    RPUZ2 = ".558072E-6 [pu/m]"
    XLPUZ2 = ".196578E-5 [pu/m]"
    BPUZ2 = "1.27727E-6 [pu/m]"
    }
   0.source_3([756,396],4,0,-1)
    {
    Name = "Source1"
    Type = "1"
    Grnd = "1"
    View = "1"
    Spec = "0"
    VCtrl = "0"
    FCtrl = "0"
    Vm = "230.0 [kV]"
    Tc = "0.05 [s]"
    f = "$(freq)"
    Ph = "0.0 [deg]"
    Vbase = "230.0 [kV]"
    Sbase = "100.0 [MVA]"
    Vpu = "1.0 [pu]"
    PhT = "0.0 [deg]"
    Pinit = "0.0 [pu]"
    Qinit = "0.0 [pu]"
    R = "1.0 [ohm]"
    Rs = "1.0 [ohm]"
    Rp = "1.0 [ohm]"
    Lp = "0.1 [H]"
    R' = "1.0 [ohm]"
    L = "0.1 [H]"
    C = "1.0 [uF]"
    L' = "0.1 [H]"
    C' = "1.0 [uF]"
    IA = ""
    IB = ""
    IC = ""
    }
   0.datalabel([846,162],2,0,-1)
    {
    Name = "Is"
    }
   0.datalabel([846,126],2,0,-1)
    {
    Name = "Vs"
    }
   -Sticky-([720,468],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 720,468,936,666
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Fault Type control:
        1 => Phase A to Ground 
        2 => Phase B to Ground 
        3 => Phase C to Ground 
        4 => Phase A,B to Ground 
        5 => Phase A,C to Ground 
        6 => Phase B,C to Ground 
        7 => Phase A,B,C to Ground 
        8 => Phase A,B 
        9 => Phase A,C 
        10=> Phase B,C 
        11=> Phase A,B,C
"
    }
   0.mrun([846,954],0,0,140)
    {
    NV = "2"
    VType1 = "0"
    IType1 = "1"
    VType2 = "2"
    IType2 = "0"
    VType3 = "0"
    IType3 = "1"
    VType4 = "0"
    IType4 = "1"
    VType5 = "0"
    IType5 = "1"
    VType6 = "0"
    IType6 = "1"
    V1Label = "Var # 1"
    V2Label = "Var # 2"
    ENAB = "1"
    V3Label = "Var # 3"
    V4Label = "Var # 4"
    V5Label = "Var # 5"
    V6Label = "Var # 6"
    STDEV = "2.0"
    V1DR = "0.0"
    V2DR = "0.0"
    V3DR = "0.0"
    V4DR = "0.0"
    V5DR = "0.0"
    V6DR = "0.0"
    V1DI = "0"
    V2DI = "1"
    V3DI = "0"
    V4DI = "0"
    V5DI = "0"
    V6DI = "0"
    N1R = "10"
    Min1R = "0.0"
    Inc1R = "0.001"
    Max1R = "0.01"
    V1Run1R = "1"
    V1Run6R = "6"
    V1Run2R = "2"
    V1Run7R = "7"
    V1Run3R = "3"
    V1Run8R = "8"
    V1Run4R = "4"
    V1Run9R = "9"
    V1Run5R = "5"
    V1Run10R = "10"
    N1I = "10"
    Min1I = "0"
    Inc1I = "1"
    Max1I = "10"
    V1Run1I = "1"
    V1Run6I = "6"
    V1Run2I = "2"
    V1Run7I = "7"
    V1Run3I = "3"
    V1Run8I = "8"
    V1Run4I = "4"
    V1Run9I = "9"
    V1Run5I = "5"
    V1Run10I = "10"
    N2R = "10"
    Min2R = "0.0"
    Inc2R = "1.0"
    Max2R = "10.0"
    V2Run1R = "1"
    V2Run6R = "6"
    V2Run2R = "2"
    V2Run7R = "7"
    V2Run3R = "3"
    V2Run8R = "8"
    V2Run4R = "4"
    V2Run9R = "9"
    V2Run5R = "5"
    V2Run10R = "10"
    N2I = "3"
    Min2I = "1"
    Inc2I = "1"
    Max2I = "10"
    V2Run1I = "1"
    V2Run6I = "6"
    V2Run2I = "4"
    V2Run7I = "7"
    V2Run3I = "7"
    V2Run8I = "8"
    V2Run4I = "4"
    V2Run9I = "9"
    V2Run5I = "5"
    V2Run10I = "10"
    N3R = "10"
    Min3R = "0.0"
    Inc3R = "1.0"
    Max3R = "10.0"
    V3Run1R = "1"
    V3Run6R = "6"
    V3Run2R = "2"
    V3Run7R = "7"
    V3Run3R = "3"
    V3Run8R = "8"
    V3Run4R = "4"
    V3Run9R = "9"
    V3Run5R = "5"
    V3Run10R = "10"
    N3I = "10"
    Min3I = "0"
    Inc3I = "1"
    Max3I = "10"
    V3Run1I = "1"
    V3Run6I = "6"
    V3Run2I = "2"
    V3Run7I = "7"
    V3Run3I = "3"
    V3Run8I = "8"
    V3Run4I = "4"
    V3Run9I = "9"
    V3Run5I = "5"
    V3Run10I = "10"
    N4R = "10"
    Min4R = "0.0"
    Inc4R = "1.0"
    Max4R = "10.0"
    V4Run1R = "1"
    V4Run6R = "6"
    V4Run2R = "2"
    V4Run7R = "7"
    V4Run3R = "3"
    V4Run8R = "8"
    V4Run4R = "4"
    V4Run9R = "9"
    V4Run5R = "5"
    V4Run10R = "10"
    N4I = "10"
    Min4I = "0"
    Inc4I = "1"
    Max4I = "10"
    V4Run1I = "1"
    V4Run6I = "6"
    V4Run2I = "2"
    V4Run7I = "7"
    V4Run3I = "3"
    V4Run8I = "8"
    V4Run4I = "4"
    V4Run9I = "9"
    V4Run5I = "5"
    V4Run10I = "10"
    N5R = "10"
    Min5R = "0.0"
    Inc5R = "1.0"
    Max5R = "10.0"
    V5Run1R = "1"
    V5Run6R = "6"
    V5Run2R = "2"
    V5Run7R = "7"
    V5Run3R = "3"
    V5Run8R = "8"
    V5Run4R = "4"
    V5Run9R = "9"
    V5Run5R = "5"
    V5Run10R = "10"
    N5I = "10"
    Min5I = "0"
    Inc5I = "1"
    Max5I = "10"
    V5Run1I = "1"
    V5Run6I = "6"
    V5Run2I = "2"
    V5Run7I = "7"
    V5Run3I = "3"
    V5Run8I = "8"
    V5Run4I = "4"
    V5Run9I = "9"
    V5Run5I = "5"
    V5Run10I = "10"
    N6R = "10"
    Min6R = "0.0"
    Inc6R = "1.0"
    Max6R = "10.0"
    V6Run1R = "1"
    V6Run6R = "6"
    V6Run2R = "2"
    V6Run7R = "7"
    V6Run3R = "3"
    V6Run8R = "8"
    V6Run4R = "4"
    V6Run9R = "9"
    V6Run5R = "5"
    V6Run10R = "10"
    N6I = "10"
    Min6I = "0"
    Inc6I = "1"
    Max6I = "10"
    V6Run1I = "1"
    V6Run6I = "6"
    V6Run2I = "2"
    V6Run7I = "7"
    V6Run3I = "3"
    V6Run8I = "8"
    V6Run4I = "4"
    V6Run9I = "9"
    V6Run5I = "5"
    V6Run10I = "10"
    NM = "4"
    OUTNAM = "mrunout.out"
    Repeat = "1"
    Opt = "4"
    MinMax = "1"
    NDIV = "10"
    MType1 = "2"
    MType2 = "2"
    MType3 = "2"
    MType4 = "2"
    MType5 = "2"
    MType6 = "2"
    RType1 = "3"
    O1Label = "Out # 1"
    RType2 = "3"
    O2Label = "Out # 2"
    RType3 = "3"
    O3Label = "Out # 3"
    RType4 = "3"
    O4Label = "Out # 4"
    RType5 = "3"
    O5Label = "Out # 5"
    RType6 = "3"
    O6Label = "Out # 6"
    }
   0.pgb([864,162],0,41640280,190)
    {
    Name = "Is"
    Group = "Bus Current"
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-10"
    Max = "10"
    }
   -Wire-([846,162],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.pgb([864,126],0,41643472,200)
    {
    Name = "Vs"
    Group = "Bus Voltage"
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200"
    Max = "200"
    }
   -Wire-([864,126],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Sticky-([72,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 72,18,1152,54
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "A SIMPLE MULTIRUN CASE"
    }
   0.datalabel([738,900],2,0,-1)
    {
    Name = "Vs"
    }
   0.datatap([756,918],0,0,30)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([738,900],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.datatap([756,954],0,0,40)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([756,990],0,0,50)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.arrow_s([792,198],6,0,-1)
    {
    }
   -Sticky-([72,756],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,756,522,1062
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Multirun component can be used to manipulate variables from one run to another.
Examples of its use are: 
  - changing the time or angle of a fault to find the worst overvoltage 
  - modifying gains of a controller to find the best response to a disturbance
  - changing the type or location of faults 
     ...
In addition, criteria defining an optimum run can be set 
  - maximum overvoltage on a 3 phase bus 
  - maximum energy in a surge arrester
     ... 

The objective of this Multiple Run is to identify which type of fault and when applied gives the maximum overvoltage

Quantities to be monitored during Multiple Run
- maximum of absolute value of bus voltages

"
    }
   -ControlPanel-([72,1098],0)
    {
    Name = "$(GROUP) : Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 72,1098
    Extents = 0,0,0,0
    Slider(25970776)
    }
   -Plot-([630,1098],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,522,414]
    Posn = [630,1098]
    Icon = [720,144]
    Extents = 0,0,522,414
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,522,176],"Voltage")
     {
     Options = 0
     Units = ""
     Curve(41643472,"Vs",0,,,)
     }
    Graph([0,176],[0,0,522,175],"Current")
     {
     Options = 0
     Units = ""
     Curve(41640280,"Is",0,,,)
     }
    }
   -Sticky-([450,486],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 450,486,684,558
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "\
Fault type
It is the second  variable changed by the Multiple Run. It takes the value from a list: 1, 4, 7"
    }
   0.multimeter([234,396],0,0,10)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "0"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "$(freq)"
    Dis = "0"
    CurI = "Is"
    VolI = "Vs"
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.unity([828,828],0,0,130)
    {
    IType = "2"
    OType = "1"
    }
   }
  }
 }

